<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:elml="http://www.elml.ch" version="2.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="../../../core/presentation/online/elml.xsl"/>
	<!-- ***** Parameter definitions  *****-->
	<!--The name of this layout (=folder name of template folder!) -->
	<xsl:param name="layout" select="'plain'"/>
	<xsl:variable name="name_furtherReading">
		<xsl:choose>
			<xsl:when test="/elml:lesson/@label='website'">
				<xsl:choose>
					<xsl:when test="$lang='de'">
						<xsl:text>Publikationen</xsl:text>
					</xsl:when>
					<xsl:when test="$lang='fr'">
						<xsl:text>Publicacions</xsl:text>
					</xsl:when>
					<xsl:when test="$lang='it'">
						<xsl:text>Publicazione</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>Publications</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="elml:get_term_name('name_furtherReading')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<!-- ***** Template definitions  ***** -->
	<xsl:template name="elml:LayoutBody">
		<body>
		    <xsl:if test="$manifest_type='scorm'">
		        <xsl:attribute name="onunload">
		            <xsl:value-of>finish()</xsl:value-of>
		        </xsl:attribute>
		    </xsl:if>
			<xsl:call-template name="elml:navigation"/>
			<a name="top"/>
			<xsl:call-template name="elml:LayoutBodyContent"/>
			<hr/>
			<xsl:call-template name="elml:footer"/>
			<xsl:call-template name="elml:cc_code"/>
		</body>
	</xsl:template>
	<xsl:template name="elml:cc_code"> &#xE001;!--<rdf:RDF xmlns="http://web.resource.org/cc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
			<Work rdf:about="">
				<license rdf:resource="http://creativecommons.org/licenses/by-nc-sa/2.5/"/>
				<dc:type rdf:resource="http://purl.org/dc/dcmitype/InteractiveResource"/>
			</Work>
			<License rdf:about="http://creativecommons.org/licenses/by-nc-sa/2.5/">
				<permits rdf:resource="http://web.resource.org/cc/Reproduction"/>
				<permits rdf:resource="http://web.resource.org/cc/Distribution"/>
				<requires rdf:resource="http://web.resource.org/cc/Notice"/>
				<requires rdf:resource="http://web.resource.org/cc/Attribution"/>
				<prohibits rdf:resource="http://web.resource.org/cc/CommercialUse"/>
				<permits rdf:resource="http://web.resource.org/cc/DerivativeWorks"/>
				<requires rdf:resource="http://web.resource.org/cc/ShareAlike"/>
			</License>
		</rdf:RDF> --&#xE002; </xsl:template>
</xsl:stylesheet>
